#!/bin/sh
get_mgmt_ipv6 () 
{
    local ha_conf='/var/local_data/conf/ha_status.conf'
    
    local key='local_mgmt_ipv6'
    local value=""
    local line=""
    
    line=`grep "^$key=" $ha_conf`
    if [ $? -ne "0" ]; then
        # $key is not found in config file
        echo "N/A"
        return 0
    fi 
    line=`echo $line | sed 's/\s*$//g'` # remove the ending space
    value=`expr $line : "$key=\(.*\)" 2>/dev/null`    
    echo $value
    return 0
}


utility_apply_ms_network_conf() {
    #dprint 0 "debug" "calling function 'utility_apply_ms_network_conf' ($1,$2,$3,$4,$5,$6,$7,$8,$9,${10},${11},${12})"
    
    local dhcp="${1}"
    local hostname="${2}"
    local ip="${3}"
    local netmask="${4}"
    local gateway="${5}"
    local ipv6="${6}"
    local ipv6_prefix="${7}"
    local ipv6_gateway="${8}"
    local dns="${9}"
    local dns2="${10}"
    local dns3="${11}"
    local interface="${12}"

    local network_ret
    network_ret=`php $CONS_BACKEND setup_server_network \
        "${dhcp}" \
        "${hostname}" \
        "${ip}" \
        "${netmask}" \
        "${gateway}" \
        "${ipv6}" \
        "${ipv6_prefix}" \
        "${ipv6_gateway}" \
        "${dns}" \
        "${dns2}" \
        "${dns3}" \
        "${interface}"`

    
    if [ "${?}" -ne 0 ]; then
        #dprint 0 "err" "fail to call \"setup_sever_network\": $network_ret"
		echo "$network_ret"
        return 1
    fi

    return 0
}



utility_tui_signal_lock() {
    trap 'int_signal_handler' SIGINT
}

utility_tui_signal_unlock() {
    trap 'exit 1' SIGINT
}

utility_reject_ctrl_c() {
    trap 'int_signal_handler' SIGINT
}

utility_accept_ctrl_c() {
    trap 'exit 1' SIGINT
}

int_signal_handler() {
    #dprint 0 "debug" "in function '${FUNCNAME[0]}'"
    
    warning "${ERROR_DO_NOT_KILL}"
}

check_create_api_key() {
    #dprint 0 "debug" "in function '${FUNCNAME[0]}'"
  ha_status=`/opt/TrendMicro/DTAS/cluster/bin/ha_ctrl.py --current-status`
  if [ $ha_status != "secondary" ];then
    # generate default API key if not found.
    local uuid=`php "${CONS_BACKEND}" get_api_key "${DTASCFG_XML_FILE}"`
    #dprint 0 "debug" "GetApiKeyFromDb: ${uuid}"

    if [ "${#uuid}" == "0" ]; then
        #dprint 0 "debug" "API key not found, create one ..."
        local tmp=`uuidgen`
        #dprint 0 "debug" "generate uuid: ${tmp}"
        
        local result
        result=`php "${CONS_BACKEND}" gen_api_key "${DTASCFG_XML_FILE}" "${tmp}"`
        #if [ "${?}" -ne 0 ]; then
           #dprint 0 "err" "failed to call gen_api_key: ${result}"
        #fi
    fi
  fi
}

check_create_server_uuid() {
    #dprint 0 "debug" 'in function "check_create_server_uuid"'
  ha_status=`/opt/TrendMicro/DTAS/cluster/bin/ha_ctrl.py --current-status`
  if [ $ha_status != "secondary" ];then
    # generate default API key if not found.
    local uuid=`php "${CONS_BACKEND}" get_server_uuid "${DTASCFG_XML_FILE}"`
    #dprint 0 "debug" "get uuid from DB: ${uuid}"

    if [ "${#uuid}" == "0" ]; then
        #dprint 0 "debug" "server uuid not found, create one ..."
        local tmp=`uuidgen`
        #dprint 0 "debug" "generate uuid: ${tmp}"
        
        local result
        result=`php "${CONS_BACKEND}" gen_server_uuid "${DTASCFG_XML_FILE}" "${tmp}"`
        #if [ "${?}" -ne 0 ]; then
           #dprint 0 "err" "failed to call gen_server_uuid: ${result}"
        #fi
    fi
  fi
}

warning_with_title() {
    local title="${1}"

    local message
    if [ -n "${3}" ]; then
        message="${2}: '${3}'"
    else
        message="${2}"
    fi

    dialog --title "${title}" --backtitle "${BACK_TITLE}" --msgbox "${message}" "${CONS_BOX_ERROR_HEIGHT}" "${CONS_BOX_ERROR_WIDTH}"
}

warning() {
    #dprint 0 "debug" 'in function "warning"'
    
    local message
    if [ -n "${2}" ]; then
        message="${1}: '${2}'"
    else
        message="${1}"
    fi

    #dprint 0 "debug" "$message"
    dialog --backtitle "${BACK_TITLE}" --msgbox "${message}" "${CONS_BOX_ERROR_HEIGHT}" "${CONS_BOX_ERROR_WIDTH}"
}

error_with_title() {
    #dprint 0 "debug" 'in function "error"'
    local title="${1}"

    
    local message
    if [ -n "${3}" ]; then
        message="${2}: '${3}'"
    else
        message="${2}"
    fi

    #dprint 0 "debug" "$message"
    dialog --title "{title}" --backtitle "${BACK_TITLE}" --infobox "${message}" "${CONS_BOX_ERROR_HEIGHT}" "${CONS_BOX_ERROR_WIDTH}"
}

error() {
    #dprint 0 "debug" 'in function "error"'
    
    local message
    if [ -n "${2}" ]; then
        message="${1}: '${2}'"
    else
        message="${1}"
    fi

    #dprint 0 "debug" "$message"
    dialog --backtitle "${BACK_TITLE}" --infobox "${message}" "${CONS_BOX_ERROR_HEIGHT}" "${CONS_BOX_ERROR_WIDTH}"
}

save_audit_log()
{
#audit log
key=${1}
if [ -z  "$SSH_CLIENT"   ];then
    key="${1}WithOutIP" 
fi
if [ -z  "${2}"   ];then
    eventtype=150  #system setting 
else
    eventtype=${2}
fi
/usr/bin/php /opt/TrendMicro/DTAS/ManagementServer/bin/audit_log/save_audit_log_cmd.php  -m TextUI -i "$SSH_CLIENT" -u "$USER" -k "$key" -t $eventtype
    
}

dprint(){
    local LOG_FILE="/opt/TrendMicro/Pixiebob/Server/logs/textUI.log"

    local level="${1}"
    local msg="${2}"
    
    local date="`date`"

    local filename="`basename "${BASH_SOURCE[1]}"`"
    local lineno="${BASH_LINENO[0]}"

    # Print error message
    echo "[${date}][${level}] ${msg} (${filename}/${lineno})" >> ${LOG_FILE}

}
